/*
 *  File:		editor.h
 *  Function:	header for the icon editor
 *  Author:		Paul Elseth
 *				Copyright (c) 1991, Paul Elseth
 *
 *	Change History:
 *
 *		12/03/91	PBE		created
 */

#ifndef	__EDITOR__
#define	__EDITOR__

#ifndef __FOUNDATION__
#include "foundation.h"
#endif
#ifndef __CONTROL__
#include <control.h>
#endif
#ifndef __QDAUX__
#include <qdaux.h>
#endif


/*	WARNING: --- if you change this structure, update fatUtils.a ----
 */
typedef struct {
	QDIconRecord	**iconH;		/* icon resource data */
    QDIconRecord	**oldIconH;		/* old icon (for colors) */
    QDIconRecord	**undoIconH;	/* undo icon */
    CtlRec			**control;		/* check box */
	GrafPort		**imageCache;	/* offscreen image image */
	GrafPort		**maskCache;	/* offscreen mask image */
	Boolean			dirty;			/* dirty */
    Rect			fatIRect;		/* fatbits image rect */
    Rect			fatMRect;		/* fatbits mask rect */
    Rect			sizeRect;		/* resize box rect */
	short			color;			/* color selected */
	short			tool;			/* tool selected */
	long			resID;			/* resource ID of the icon */
	} IconData;


extern Picture	**gToolsPicH;		/* tool palette picture */
extern short	gToolsPicWidth;		/* width of tool palette picture */
extern short	gToolsPicHite;		/* width of tool palette picture */

enum { kPencilTool, kBucketTool, kEraserTool, kPickerTool, kShifterTool };


short 	OpenEditor(fOpenRec *parms);
short	EditorEvent(fEventRec *parms);
short	CloseEditor(fCloseRec *parms);
short	WriteEditor(fCloseRec *parms);
short	ActivateEditor(fActivateRec *parms);
short	EditorGetLink(fLinkRec *parms);
short	EditorVidMode(fVidModeRec *parms);
short	EditorPrint(fCloseRec *parms);

void	CalcFat(IconData** idH);
void	DrawEm(IconData **dataH);
void	EraseEm(IconData **dataH);
void	UpdateEm(IconData **dataH);
void	RedrawFatbits(IconData **dataH, Boolean mask);

#endif	/* __EDITOR__ */
